﻿DROP PROCEDURE [hips].[PcehrMessageQueueCountPending]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
 
-- Create date:   13 Sept 2013
-- Description:   Counts the Pending PcehrMessageQueues for the specific episode that are before the specified datetime
-- =============================================
CREATE PROCEDURE [hips].[PcehrMessageQueueCountPending] 
(
	    @SourceSystemSetId VARCHAR(128)
	   ,@CreatedDateTime DATETIME
	   ,@PcehrMessageQueueId INT
) AS
BEGIN

	SELECT  
		COUNT(*)
	FROM  hips.PcehrMessageQueue As pmq
	INNER JOIN hips.QueueStatus As qs on qs.QueueStatusId = pmq.QueueStatusId
	INNER JOIN hips.QueueOperation AS qo ON qo.QueueOperationId = pmq.QueueOperationId
		WHERE SourceSystemSetId = @SourceSystemSetId
		AND pmq.QueueStatusId = 1
		AND pmq.PcehrMessageQueueId != @PcehrMessageQueueId
		AND pmq.DateCreated < @CreatedDateTime

END
GO
